unit Main;

{
This little program gives you a list of all procedures and functions
in the currently displayed source code and makes the Delphi IDE jump
to definition of the selected proc.
Simple but useful  :o)   **FREEWARE**
You can reach my by EMail at CIS:      100325,3701
                             Internet: 100325.3701@compuserve.com


Installation:
put the EXE and the sendkeys.dll in your delphi directory and add
a line to your tools-menu in the IDE, e.g.:

Title:      &TProcFinder
Program:    c:\delphi\bin\procfind.exe
Directord:
Params:     $SAVEALL $PATH($EDNAME)$NAME($EDNAME)

                    ^ just one blank

That's it <g>.
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, ExtCtrls, SendKey;

type
  TFormMain = class(TForm)
    Panel1: TPanel;
    ListBox: TListBox;
    BtnClose: TSpeedButton;
    BtnFind: TSpeedButton;
    Edit: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure BtnFindClick(Sender: TObject);
    procedure BtnCloseClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure EditChange(Sender: TObject);
    procedure EditKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure ListBoxKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
  private
  public
  end;


  (* Object to hold the line numbers *)
  TProcLine = class
    l : Integer;
    constructor Create(i : Integer);
    function AsInteger : Integer;
  end;


var
  FormMain: TFormMain;


implementation

{$R *.DFM}

(*****************************************************************************)
(* TProcLine                                                                 *)
(*****************************************************************************)
constructor TProcLine.Create(i : Integer);
begin
  inherited Create;
  l := i;
end;

function TProcLine.AsInteger : Integer;
begin  Result := l;  end;


(*****************************************************************************)
(* Form creation parses the .PAS file                                        *)
(*****************************************************************************)
procedure TFormMain.FormCreate(Sender: TObject);
var f : TextFile;
    fn, s, t : String;
    i, l, a, b : Integer;
begin
  fn := StrPas(CmdLine);    (* get the path/name of the .pas *)
  if fn = '' then EXIT;
  AssignFile(f, fn);
  Reset(f);                 (* open the file *)
  l := 0;                   (* l is the line counter *)
  try
    repeat  (* scan for 'implementation *)
      Readln(f, s);  LowerCase(s);
      inc(l);
    until eof(f) or (Pos('implementation', s) > 0);

    Readln(f, s);  t := s;  LowerCase(s);
    i := 0;   inc(l);
    (* scan for keywords 'procedure' or 'function' *)
    while (not eof(f)) and (l < 30000) do begin
      Readln(f, s);
      t := s;
      LowerCase(s);
      inc(l);
      a := Pos('procedure', s);
      if a = 0 then a := Pos('function', s);
      if (a > 0) and (a < 6) then begin  (* no keyword must be right of 6th column *)
        (* add proc to listbox and the line number, too *)
        ListBox.Items.AddObject(Copy(t, a, 128), TProcLine.Create(l));
        inc(i);
      end;
      if (l mod 10) = 0 then Application.ProcessMessages;  (* just in case...*)
    end;
  finally
    CloseFile(f);
  end;
  if ListBox.Items.Count > 0 then Listbox.ItemIndex := 0;
end;


procedure TFormMain.BtnFindClick(Sender: TObject);
var HWndEdit : HWND;
    s : String;
    l : Integer;
begin
  (* get the handle of Delphi's edit window; seems to work reliably <g> *)
  HWndEdit := FindWindow('TEditWindow', nil);
  if HWndEdit > 0 then begin
    BringWindowToTop(hWndEdit);
    Application.ProcessMessages;    (* don't ask me why, but...               *)
    BringWindowToTop(hWndEdit);     (* works better when doing this two times *)
    WinProcs.SetFocus(hWndEdit);    (* put cursor and focus to that window    *)
    WinProcs.SetCapture(hWndEdit);

    (* get the line number from the listbox *)
    l := TProcLine(ListBox.Items.Objects[ListBox.ItemIndex]).AsInteger;

    (* emulate key presses to Delphi's edit window; opens Goto Line: - Dialog *)
    s := '^o^g' + IntToStr(l) + '{enter}';
    SendKeysStr(s);

    Close;  (* Close the ProcFinder *)
  end;
end;


procedure TFormMain.BtnCloseClick(Sender: TObject);
begin
  Close;
end;


procedure TFormMain.FormDestroy(Sender: TObject);
var i : Integer;
begin
  (* free all line-number objects *)
  for i:=0 to ListBox.Items.Count-1 do begin
    ListBox.Items.Objects[i].Free;
  end;
end;


procedure TFormMain.EditChange(Sender: TObject);
var i, n, a : Integer;
begin
  i := -1;  n := ListBox.Items.Count-1;
  repeat
    inc(i);
    a := Pos(Edit.Text, ListBox.Items[i]);
  until (i=n) or (a > 0);
  if a > 0 then ListBox.ItemIndex := i;
end;


procedure TFormMain.EditKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if Key = vk_Return then ListBox.SetFocus;
end;


procedure TFormMain.ListBoxKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if Key = vk_Return then BtnFindClick(Sender);
end;

end.
